# PS1 “Advanced Advanced” Ripping

## TOOLS
- CDMAGE
- JPSXDEC
- PSX-MODE2-EN

## SINGLE CUE+BIN PREPARATION
If there are multiple bins (audio tracks) then you will need to resave the CD image as a single bin+cue as this enables us to replace and rip more easily and successfully:
1. Open .cue file in CDMAGE
2. Choose “Save As”
3. Choose a new location to save the single cue+bin

# RIPPING DUMMY FILES

Dummy files were used to force the position of the game data towards the outside of the CD - the fastest spinning part of the disc - so that game data could be read more quickly. They are always the last file(s) on the CD, often with a odd filename such as one containing Zs (to force them to sort last alphabetically), BLANK, ZERO, DUMMY, or something similar. Dummy files are often blank though they can sometimes contain data, often random data the developer had to hand. Presence of a dummy file . 

If in doubt, try replacing the last file and see if the game still works.

##PSX-MODE2-EN
We use this app because it:
- allows exact control of file ripping/replacement
- replaces files quickly
- reduces the size of the CD image at the same time (other tools replace the file and do not shrink the space it took up)

## CRASH BANDICOOT
Difficulty: Advanced Easy
Inital CD: 602MB
To Do: remove one large dummy file
Path:
	\ZBSPTREE.WAD
Replacement:
	BLANKS\DUMMY\BLANK.DAT (1 byte)
Command: 
	psx-mode2-en.exe "Crash Bandicoot (USA).bin" \ZBSPTREE.WAD BLANK.DAT
Final EBOOT: 174MB

So that was easy, and we’ve saved a whole bunch of space!

But what about if we want to reduce the size by getting rid of movies we don’t want to watch over and over? Well we can do this by replacing the movie with a much smaller file. PocketISO offers limited control over this, by replacing the movie with either a zero length file or the smallest movie already on the CD. But doesn’t work with all games.

Replacing movies is trickier than replacing a dummy file, for a couple of reasons. First is that there are a few different types of movies, and second is that we don’t know how the game will react when the movie is replaced with a blank file or shorter movie. There’s a bit of trial and error involved here, though there are a few shortcuts we can use as we’ll see.

The first thing you want to do is identify the movies you’d like to replace. 
1. Open single BIN in JPSXDEC
2. Click “Close”
3. Find the movie file
4. Highlight the line with the movie icon 
5. Click “Play” tab
6. Click “Play” button
7. Make a note of the filename

## TWISTED METAL: PART 1
Difficulty: Advanced Easy
To Do: identify the unwanted movie files
	\MOVIES\SLOGO15S.STR = SingletracLOGO
	\UAMOVIES\TMDMO15S.STR = TwistedMetalDeMO
	\UAMOVIES\TMTTL15S.STR = TwistedMetalTiTLe
	\UAMOVIES\WHDMO15S.STR = WarHawkDeMO
We’ll keep the Title movie but replace the other three.

But which of our “blank” STR files should we use as the replacement?
Well, that depends on the size of the video we are replacing as we need to respect the way files are stored on the CD.
We can see our blank STR files have numbers in the filename.
If the filesize (in bytes) of the movie we are replacing divides cleanly by 2048, 2336 then we use an STR named with that number.

## TWISTED METAL: PART 2
Difficulty: Advanced Hard
Inital CD: 325MB
To Do: replace three unwanted movie files
Sizes: 
	\UAMOVIES\TMDMO15S.STR
		20,496,384 bytes divided by 2048 = 10008
	\UAMOVIES\WHDMO15S.STR
		17,563,648 bytes divided by 2048 = 8576
	\MOVIES\SLOGO15S.STR
		3,063,808 bytes divided by 2048 = 1496
So we can use either of black2048.str  or spinner2048.str.
The two in UAMOVIES replace with black2048 just fine.
Using black2048 to replace the one in MOVIES results in a black menu screen.
So instead we use spinner2048.str and the game menu displays just fine!
Commands: 
	psx-mode2-en.exe "Twisted Metal (USA).bin" \UAMOVIES\TMDMO15S.STR black2048.str
	psx-mode2-en.exe "Twisted Metal (USA).bin" \UAMOVIES\WHDMO15S.STR black2048.str
	psx-mode2-en.exe "Twisted Metal (USA).bin" \MOVIES\SLOGO15S.STR spinner2048.str
Final EBOOT: 211MB
